<?php

/**
 * Do not change this value if there is no DataTables translation available for your language.
 * You can check out the available translations using the following link.
 * @link https://datatables.net/plug-ins/i18n/
 */
$GLOBALS["dataTablesLanguage"] = "de-DE";

$lang = [
    'removed_from_blacklist' => 'Ihre Nummer wurde erfolgreich von der Blacklist entfernt.',
    'deplete_credit_for_each_sms_part_label' => 'Verbrauchen Sie 1 Guthaben für jeden SMS-Teil',
    'success_blacklisted' => 'Sie erhalten keine Nachrichten mehr von uns. Teilen Sie uns mit, wenn Sie Ihre Meinung ändern.',
    'use_credits_for_received_messages' => 'Verwenden Sie Credits für empfangene Nachrichten',
    'disabled' => 'Deaktiviert',
    'enable_received_message_notification' => 'Benachrichtigung über den Nachrichtenbrowser erhalten',
    'enable_realtime_dashboard' => 'Dashboard-Statusaktualisierungen in Echtzeit',
    'integrations' => 'Integrationen',
    'features' => 'Merkmale',
    'disabled_by_admin' => 'Vom Administrator deaktiviert',
    'remaining' => 'Übrig',
    'per_message' => 'Pro Nachricht',
    'length' => 'Länge',
    'encoding' => 'Codierung',
    'expired' => 'Abgelaufen',
    'admin' => 'Admin',
    'info' => 'Info',
    'subscription' => 'Abonnement',
    'mass_mms_instructions' => '<p>Sie können eine Massen-MMS senden, indem Sie die Mobiltelefonnummern mit dem Pipe-Symbol (|) anstelle des Kommas (,) trennen. Es sendet eine MMS an mehrere Nummern, ähnlich wie die BCC-Funktionalität in E-Mails. Betrachten Sie beispielsweise die folgenden Zahlen.</p>
<p style="word-break: break-all">+11234567890|+12345678901|+13456789012,+14567890123,+15678901234</p>
<p>Wenn Sie auf diese Weise Mobiltelefonnummern eingeben, werden drei Nachrichten gesendet. Die erste Nachricht ist eine Massennachricht an +11234567890, +12345678901 und +13456789012.</p>
<p>Dies funktioniert nur, wenn Ihr Netzbetreiber Massen-MMS unterstützt.</p>',
    'announcement_setting' => 'Bekanntmachung',
    'error_invalid_firebase_service_account_json' => 'Der JSON-Code des Firebase-Dienstkontos ist ungültig!',
    'firebase_service_account' => 'Firebase-Dienstkonto',
    'canceled' => 'Abgesagt',
    'no_data' => 'Keine Daten',
    'last_login_ip' => 'Letzte Anmelde-IP',
    'message_placeholder' => 'Sie können die Nachricht randomisieren, indem Sie Spintax wie unten gezeigt verwenden.
&quot;{Hallo|Hi|Hey} %name%, Wie geht es Ihnen?&quot;',
    'ussd_delay' => 'Verzögerung vor USSD-Anfrage',
    'how_to_get_it' => 'Wie bekomme ich es?',
    'tooltip_ussd' => 'Eine mehrstufige USSD-Anforderung wartet bis zu 30 Sekunden auf die nächste Eingabe, sodass Sie in diesem Zeitrahmen eine weitere Anforderung mit der Eingabe senden können, um mit dem nächsten Schritt fortzufahren. Wenn Sie beispielsweise eine mehrstufige Anfrage initiieren und diese 1,2,3 oder 4 als Eingabe akzeptiert, können Sie eine weitere Anfrage mit einer der akzeptierten Eingaben (1,2,3 oder 4) senden, und dies führt zu a Bitte um diesen Schritt.',
    'tooltip_ussd_delay' => 'Sie sollten eine Verzögerung von mindestens 30 Sekunden einstellen, wenn Sie nur eine einstufige USSD-Anforderung verwenden möchten. Eine mehrstufige USSD-Anforderung wartet bis zu 30 Sekunden auf die nächste Eingabe. Wenn Sie also vor dieser Zeit eine neue USSD-Anforderung senden, wird diese als Eingabe für die vorherige mehrstufige Anforderung betrachtet.',
    'ssl_verification' => 'SSL-Verifizierung',
    'off' => 'Aus',
    'on_recommended' => 'Ein (empfohlen)',
    'tooltip_only_shared_devices' => 'Sie können es auf 0 setzen, wenn Sie möchten, dass der Benutzer nur vom Administrator freigegebene Geräte verwendet. Es verhindert, dass der Benutzer sein eigenes Gerät zum System hinzufügt.',
    'selected_users' => 'Ausgewählte Benutzer',
    'demo_users' => 'Demo-Benutzer',
    'share_with' => 'Teilen mit',
    'shared_devices' => 'vom Administrator freigegebene Geräte',
    'skin_setting' => 'Haut',
    'black' => 'Weiß',
    'black_light' => 'Weißes Licht',
    'blue' => 'Blau',
    'blue_light' => 'Blaues Licht',
    'green' => 'Grün',
    'green_light' => 'Grünes Licht',
    'purple' => 'Lila',
    'purple_light' => 'Lila Licht',
    'red' => 'Rot',
    'red_light' => 'Rotes Licht',
    'yellow' => 'Gelb',
    'yellow_light' => 'Gelbes Licht',
    'add_numbers_blacklist_placeholder' => 'Geben Sie eine Handynummer pro Zeile ein',
    'use_owner_settings' => 'Verwenden Sie vom Administrator festgelegte gerätebezogene Einstellungen (Verzögerung, Zustellungsberichte und progressive Warteschlange).',
    'get_devices' => 'Geräte erhalten',
    'use_progressive_queue_setting' => 'Nächste Nachricht in der Kampagne erst senden, nachdem die aktuelle Nachricht vom Netzbetreiber verarbeitet wurde',
    'hint' => 'Hinweis!',
    'blacklist_instruction' => 'Benutzer können ihre Nummer zur schwarzen Liste hinzufügen, indem sie auf Ihre Nachricht mit "STOP" antworten.',
    'error_no_valid_numbers_found' => 'Es wurden keine gültigen Nummern gefunden, die zur schwarzen Liste hinzugefügt werden können.',
    'success_numbers_removed' => '%count% Nummern erfolgreich entfernt.',
    'success_number_removed' => '%count% Nummer erfolgreich entfernt.',
    'success_add_to_blacklist' => 'Erfolgreich zur Blacklist hinzugefügt.',
    'remove_number_from_black_list_confirmation' => 'Möchten Sie die ausgewählten Nummern wirklich von der schwarzen Liste entfernen?',
    'add' => 'Addieren',
    'blacklist' => 'Schwarze Liste',
    'unshareable' => 'Unteilbar',
    'error_device_not_owned' => 'Sie können USSD-Anfragen nur mit Ihren eigenen Geräten senden.',
    'no_one' => 'Niemand',
    'shared_with' => 'Geteilt mit',
    'share_to_all' => 'Für alle freigeben',
    'success_device_shared' => 'Gerät erfolgreich freigegeben/nicht freigegeben.',
    'users' => 'Benutzer',
    'share_device' => 'Gerät teilen',
    'all' => 'Alle',
    'error_unable_to_remove_plans' => 'Ausgewählte Pläne können nicht entfernt werden.',
    'remove_plans_confirmation' => 'Möchten Sie die ausgewählten Pläne wirklich entfernen?',
    'success_plans_removed' => '%count% Pläne erfolgreich entfernt.',
    'success_plan_removed' => '%count%-Plan erfolgreich entfernt.',
    'success_regenerate_api_key' => 'API-Schlüssel erfolgreich neu generiert.',
    'regenerate_api_key_confirmation' => 'Möchten Sie den API-Schlüssel wirklich neu generieren? Ihr alter Schlüssel wird nicht mehr funktionieren, wenn Sie dies tun!',
    'resend_requests_confirmation' => 'Möchten Sie die ausgewählten USSD-Anfragen wirklich erneut senden?',
    'success_ussd_requests_resent' => '%count% USSD-Anfragen erfolgreich erneut gesendet.',
    'success_ussd_request_resent' => '%count% USSD-Anfrage erfolgreich erneut gesendet.',
    'move_contacts' => 'Kontakte verschieben',
    'success_contacts_moved' => '%count% Kontakte wurden erfolgreich verschoben.',
    'success_contact_moved' => '%count% Kontakt wurde erfolgreich verschoben.',
    'move_contacts_confirmation' => 'Möchten Sie die ausgewählten Kontakte wirklich verschieben?',
    'move' => 'Bewegung',
    'new_user_report_delivery_setting' => 'Anfordern eines Zustellberichts für jede vom Benutzer gesendete Nachricht (nur SMS)',
    'tooltip_sleep_time' => 'Wenn aktiviert, wird das Senden aller nicht priorisierten Nachrichten in diesem Zeitintervall verhindert.',
    'appearance' => 'Aussehen',
    'reset_password_link' => 'Passwort-Link zurücksetzen',
    'user_limits_update' => 'Aktualisierung der Benutzerbeschränkungen',
    'subject' => 'Gegenstand',
    'unsubscribe' => 'Abbestellen',
    'copyright' => 'Urheberrechte',
    'android_app' => 'Android App',
    'links' => 'Links',
    'default_settings_new_users' => "Standardeinstellungen für neue Benutzer",
    'new_user_limitations' => "Neue Benutzerbeschränkungen",
    'message_footer_demo_users' => 'Nachrichten-Fußzeile für Demo-Benutzer',
    'download_app' => 'Lade App herunter',
    'no_ussd_requests_found' => 'Keine USSD-Anfragen gefunden.',
    'error_sim_not_exist' => 'Stellen Sie sicher, dass Sie auf dem Gerät #%deviceId% bei der App angemeldet sind und sich eine SIM-Karte in Slot %simSlot% befindet. Wenn Sie es kürzlich eingefügt haben, öffnen Sie die App auf dem Telefon, um es der Datenbank hinzuzufügen.',
    'error_device_not_exist' => 'Die von Ihnen angegebene Geräte-ID wurde nicht in der Datenbank gefunden oder Sie sind nicht in der App angemeldet.',
    'success_ussd_requests_removed' => '%count% USSD-Anfragen wurden erfolgreich entfernt.',
    'success_ussd_request_removed' => '%count% USSD-Anfrage erfolgreich entfernt.',
    'success_sent_ussd_request' => 'USSD-Anfrage erfolgreich gesendet.',
    'remove_requests_confirmation' => 'Möchten Sie die ausgewählten USSD-Anfragen wirklich entfernen?',
    'response_at' => 'Antwort bei',
    'sent_at' => 'Gesendet um',
    'request' => 'Anfrage',
    'ussd_requests' => 'USSD-Anfragen',
    'ussd_request' => 'USSD-Anfrage',
    'send_ussd_request' => 'USSD-Anfrage senden',
    'get_ussd_requests' => 'USSD-Anfragen erhalten',
    'ussd' => 'USSD',
    'error_missing_data' => 'Es fehlen erforderliche Daten, um sich von der Liste abzumelden. Stellen Sie sicher, dass Sie die vollständige URL aus der Nachricht kopieren.',
    'error_paypal_requires_ssl' => 'Sie benötigen ein installiertes SSL-Zertifikat für Ihre Domain oder Subdomain, um PayPal nutzen zu können. Wenn Sie es bereits installiert haben, stellen Sie sicher, dass Sie dies von einer URL aus tun, die mit "https" beginnt.',
    'tooltip_prioritize' => 'Senden Sie diese Nachricht sofort, auch wenn sich noch eine andere Kampagne in der Warteschlange befindet.',
    'add_device_instruction' => 'Sie können die folgenden Schritte ausführen, um Ihr Android-Telefon zum System hinzuzufügen.',
    'error_invalid_sleep_time' => 'Bitte geben Sie einen gültigen Wert für die Schlafzeit an. Schlafzeit von und bis Wert muss unterschiedlich sein.',
    'sleep_time_from' => 'Schlafenszeit von',
    'sleep_time_upto' => 'Schlafzeit bis zu',
    'sleep_time' => 'Schlafenszeit',
    'prioritize' => 'Priorisieren',
    'success_contacts_list_updated' => 'Contacts List name updated successfully.',
    'edit_contacts_list' => 'Edit Contacts List',
    'edit_list' => 'Edit List',
    'error_creating_lock_file' => 'There is an error while creating lock file. Please make sure this script has necessary permissions to create a directory.',
    'refresh' => 'Refresh',
    'success_queued_contacts_import' => 'Contacts file import queued successfully.',
    'error_creating_directory' => 'There is an error while creating %name% directory. Please make sure this script has necessary permissions to create a directory.',
    'footer_text_label' => 'Fußzeile Absatz',
    'option' => 'Geräte Auswahlkriterien',
    'use_selected_devices' => 'Verwenden Sie ausgewählte Geräte',
    'use_all_devices' => 'Verwenden Sie die Standard-SIM aller Geräte',
    'use_all_sims' => 'Verwenden Sie alle SIM-Karten von allen Geräten',
    'use_random_device' => 'Verwenden Sie ein zufälliges Gerät oder eine SIM-Karte von ausgewählten Geräten',
    'tooltip_android_app_url' => 'Diese URL wird als Link zur APK-Datei in der Registrierungs-E-Mail und an anderen Stellen verwendet. Stellen Sie daher sicher, dass Sie sie in Ihre APK-URL ändern.',
    'tooltip_mms' => 'Die Verfügbarkeit von MMS hängt von Ihrem Land und der Unterstützung durch Ihren Netzbetreiber ab. Der Empfänger muss in der Lage sein, MMS zu empfangen, um es zu empfangen. Diese Funktion sollte nicht mit RCS oder anderen vom Gerätehersteller bereitgestellten Messaging-Funktionen (z. B. Samsung-Nachricht, Mi-Nachricht usw.) verwechselt werden.',
    'tooltip_attachments' => 'Sie können hier mehrere Dateien anhängen, aber stellen Sie sicher, dass Sie die Gesamtgröße von 600 KB nicht überschreiten. Wenn der Empfänger die MMS immer noch nicht empfangen kann, können Sie versuchen, 300 KB nicht zu überschreiten.',
    'attachments_invalid' => 'Von Ihnen bereitgestellte Bildanhänge sind ungültig.',
    'resend_messages' => 'Nachrichten erneut senden',
    'error_creating_upload_directory' => 'Beim Erstellen des Upload-Verzeichnisses ist ein Fehler aufgetreten. Stellen Sie sicher, dass das Skript über die Berechtigung zum Erstellen eines Ordners verfügt.',
    'error_uploading_attachment' => 'Beim Hochladen von Anhängen ist ein Fehler aufgetreten. Stellen Sie sicher, dass das Skript über die Berechtigung zum Schreiben in den Upload-Ordner verfügt.',
    'tooltip_attachments_links' => 'Sie können mehrere Bildverknüpfungen bereitstellen, indem Sie sie durch Komma trennen. Stellen Sie jedoch sicher, dass vor oder nach dem Komma kein Leerzeichen vorhanden ist.',
    'attachments_links' => 'Links zu Anhängen (*.png, *.jpg, *.gif, *.aac, *.3gp, *.amr, *.mp3, *.m4a, *.wav, *.mp4, *.txt, *.vcf, *.html)',
    'attachments' => 'Anhänge (*.png, *.jpg, *.gif, *.aac, *.3gp, *.amr, *.mp3, *.m4a, *.wav, *.mp4, *.txt, *.vcf, *.html)',
    'type' => 'Art',
    'success_device_name_updated' => 'Gerätename erfolgreich gespeichert.',
    'edit_device' => 'Gerät bearbeiten',
    'send_received_messages_to_email' => 'Empfangene Nachrichten per E-Mail senden',
    'error_server_requirements_not_met' => 'Ihr Server erfüllt die Anforderungen nicht. Wenden Sie sich an Ihren Serveradministrator, um fehlende Abhängigkeiten zu installieren.',
    'next' => 'Nächster',
    'none' => 'Keiner',
    'success_templates_removed' => '%count% Vorlagen erfolgreich entfernt.',
    'success_template_removed' => '%count% Vorlage erfolgreich entfernt.',
    'success_update_template' => 'SMS-Vorlage erfolgreich aktualisiert.',
    'success_add_template' => 'SMS-Vorlage erfolgreich hinzugefügt.',
    'remove_templates_confirmation' => 'Möchten Sie wirklich ausgewählte SMS-Vorlagen entfernen?',
    'manage_templates' => 'Vorlagen verwalten',
    'add_template' => 'Vorlage hinzufügen',
    'templates' => 'Vorlagen',
    'template' => 'Vorlage',
    'tooltip_delay' => 'Sie können einen Bereich für zufällige Verzögerungen zuweisen. Wenn Sie beispielsweise 20-40 als Verzögerungswert zuweisen, wird die Verzögerung für jede Nachricht zufällig ausgewählt und liegt zwischen 20 und 40 Sekunden.',
    'error_invalid_delay' => 'Die Verzögerung sollte numerisch sein (z.B. 20) oder den Bereich darstellen (z.B. 20-60).',
    'error_max_delay_smaller' => 'Die maximale Verzögerung sollte größer sein als die minimale Verzögerung.',
    'error_disposable_email_address' => 'Bitte verwenden Sie eine nicht temporäre E-Mail-Adresse für die Registrierung!',
    'placeholder_auto_responder_message' => 'Sie können das Symbol | verwenden, um mehrere Nachrichten zu trennen. Wenn Ihre Nachricht | enthält, können Sie \| anstelle von | verwenden.',
    'tooltip_total_cycles' => 'Aktivieren Sie diese Option, um die Anzahl der Gebühren für das Abonnement zu begrenzen. Wenn Sie es nicht aktivieren, bleibt ein Abonnement für diesen Plan aktiv, bis es gekündigt wird.',
    'cancelled' => 'abgesagt',
    'renews_until' => 'Erneuert bis',
    'refund' => 'Rückerstattung',
    'error_payment_not_found' => 'Die Zahlung kann nicht gefunden werden!',
    'success_payment_refunded' => 'Die Zahlung wurde erfolgreich zurückerstattet.',
    'refund_payment_confirmation' => 'Möchten Sie diese Zahlung wirklich erstatten?',
    'error_user_already_subscribed' => 'Es kann kein neues Abonnement erstellt werden, da für diesen Benutzer bereits ein aktives Abonnement vorhanden ist.',
    'success_create_subscription' => 'Ein neues Abonnement wurde erfolgreich hinzugefügt.',
    'year' => 'Jahr',
    'month' => 'Monat',
    'week' => 'Woche',
    'create_subscription' => 'Abonnement erstellen',
    'error_total_cycles_not_number' => 'Die Gesamtzyklen sollten eine Zahl und größer als Null sein.',
    'total_cycles' => 'Gesamtzyklen',
    'excel_message_placeholder' => 'Sie können einen Platzhalter wie in der folgenden Meldung gezeigt verwenden, der automatisch durch einen geeigneten Wert ersetzt wird. Es unterstützt auch das Randomisieren von Nachrichten mit Spintax.
&quot;{Hallo|Hi|Hey} %name%, Wie geht es Ihnen?&quot;
Im obigen Beispiel ersetzt das System %name% durch Daten aus der Spalte Name. Sie müssen die Spalte Name in Ihrer Excel-Datei haben, damit dies funktioniert.',
    'do_not_have_an_account' => 'Sie haben noch keinen Account?',
    'user' => 'Benutzer',
    'from_name' => 'Von Namen',
    'from_address' => 'Von E-Mail Adresse',
    'tooltip_unsubscribe_url' => 'Sie können eine verkürzte URL für die Abmelde-URL hinzufügen, um Platz in Ihrer Nachricht zu sparen.',
    'tooltip_max_retries' => 'Die maximale Häufigkeit, mit der das System das Senden fehlgeschlagener Nachrichten wiederholen sollte.',
    'tooltip_retry_time_interval' => 'Die Zeitspanne zwischen jedem erneuten Versuch fehlgeschlagener Nachrichten.',
    'smtp_debug_information' => 'SMTP-Debug-Informationen',
    'show_debug_info' => 'Debug-Informationen anzeigen',
    'tooltip_message_multiple' => 'Wenn Sie etwas in dieses Feld eingeben, werden nur Handynummern aus der Excel-Datei verwendet.',
    'buy_now' => 'Kaufe jetzt',
    'favicon' => 'Favicon',
    'error_uploading_logo' => 'Beim Hochladen des Logos ist ein Fehler aufgetreten. Stellen Sie sicher, dass das Skript über die Berechtigung zum Schreiben in den Upload-Ordner verfügt.',
    'logo' => 'Logo',
    'expires_after' => 'Läuft ab nach',
    'add_unsubscribe_link' => 'Link zum Abbestellen hinzufügen',
    'cycles_competed' => 'Zyklen abgeschlossen',
    'respond_if' => 'Antworte wenn',
    'exact_case_sensitive' => 'Genaue Übereinstimmung (Groß- und Kleinschreibung beachten)',
    'exact_case_insensitive' => 'Genaue Übereinstimmung (Groß- und Kleinschreibung wird nicht berücksichtigt)',
    'contains' => 'Enthält die Nachricht',
    'regular_expression' => 'Entspricht dem regulären Ausdruck',
    'success_update_response' => 'Antwort erfolgreich aktualisiert.',
    'edit_response' => 'Antwort bearbeiten',
    'success_responses_removed' => '%count% Antworten erfolgreich entfernt.',
    'success_response_removed' => '%count% Antwort erfolgreich entfernt.',
    'remove_responses_confirmation' => 'Möchten Sie ausgewählte Antworten wirklich entfernen?',
    'error_unable_to_remove_responses' => 'Ausgewählte Antworten können nicht entfernt werden',
    'response' => 'Antwort',
    'success_add_response' => 'Antwort erfolgreich hinzugefügt.',
    'responses' => 'Antworten',
    'add_response' => 'Antwort hinzufügen',
    'auto_responder' => 'Automatische Antwort',
    'unlimited_credits' => 'Unbegrenzte Guthaben',
    'credit' => 'Guthaben',
    'error_contacts_limit_reached' => 'Die maximal zulässige Anzahl von Kontakten für dieses Konto wurde überschritten.',
    'contact' => 'Kontakt',
    'unlimited_contacts' => 'unbegrenzte Kontakte',
    'unlimited_devices' => 'unbegrenzte Geräte',
    'max_contacts' => 'Max Kontakte',
    'error_max_contacts_not_number' => 'Die maximale Anzahl von Kontakten sollte eine Anzahl sein.',
    'earnings' => 'Verdienste',
    'active_subscriptions' => 'Aktive Abonnements',
    'auto_retry_setting' => 'Fehlgeschlagene Nachrichten automatisch wiederholen',
    'hour' => 'Stunde',
    'hours' => 'Std',
    'day' => 'Tag',
    'minutes' => 'Protokoll',
    'retry_time_interval_label' => 'Wiederholen Sie das Zeitintervall',
    'max_retries_label' => 'Max versucht es erneut',
    'error_subscription_expired' => 'Dein Abonnement ist abgelaufen. Erneuern Sie Ihr Abonnement, um diese Anwendung weiterhin zu verwenden.',
    'no' => 'Nein',
    'yes' => 'Ja',
    'all_time' => 'Alle Zeit',
    'never' => 'noch nie',
    'days' => 'Tage',
    'cancel_subscription_confirmation' => 'Möchten Sie dieses Abonnement wirklich kündigen?',
    'id' => 'ICH WÜRDE',
    'reply' => 'Antworten',
    'unlimited' => 'Unbegrenzt',
    'forever' => 'Ende der Welt',
    'expiry_date' => 'Verfallsdatum',
    'payment_id' => 'Zahlungs-ID',
    'amount' => 'Menge',
    'transaction_fee' => 'Transaktionsgebühr',
    'payments' => 'Zahlungen',
    'payment_method' => 'Bezahlverfahren',
    'subscribed_date' => 'Abonniertes Datum',
    'renew_date' => 'Erneuerungsdatum',
    'subscription_id' => 'Abonnement-ID',
    'plan_already_exists' => 'Plan mit demselben Namen existiert bereits.',
    'switch_plan' => 'Plan wechseln',
    'success_subscription_canceled' => 'Abonnement erfolgreich gekündigt.',
    'error_subscription_not_found' => 'Abonnement konnte nicht gefunden werden!',
    'success_subscribed' => 'Sie haben das Abonnement erfolgreich abonniert.',
    'cancel' => 'Stornieren',
    'subscribe' => 'Abonnieren',
    'subscriptions' => 'Abonnements',
    'success_edit_plan' => 'Das Abonnement wurde erfolgreich aktualisiert.',
    'enabled' => 'aktiviert',
    'billing_cycle' => 'Rechnungskreislauf',
    'success_create_plan' => 'Erfolgreich ein neues Abonnement hinzugefügt.',
    'edit_plan' => 'Plan bearbeiten',
    'frequency_unit' => 'Frequenzeinheit',
    'frequency' => 'Frequenz',
    'currency' => 'Währung',
    'price' => 'Preis',
    'add_plan_form_title' => 'Plan hinzufügen',
    'plans' => 'Pläne',
    'plan' => 'Planen',
    'error_updating_config' => 'Konfigurationsdatei kann nicht aktualisiert werden. Stellen Sie sicher, dass dieses Skript über die entsprechende Berechtigung zum Aktualisieren einer Datei verfügt.',
    'enable_registration' => 'Registrierung aktivieren',
    'error_invalid_integer_value' => 'Ungültiger Wert für %field% angegeben. Es sollte ein gültiger numerischer Wert sein.',
    'credentials_type' => 'Typ der Anmeldeinformationen',
    'client_id' => 'Kunden ID',
    'secret' => 'Geheimnis',
    'payment_gateway' => 'Zahlungs-Gateways',
    'emails' => 'E-Mails',
    'success_save_settings' => 'Einstellungen erfolgreich gespeichert.',
    'general' => 'Allgemeines',
    'registration' => 'Anmeldung',
    'site_name' => 'Site-Name',
    'site_description' => 'Seitenbeschreibung',
    'copyright_name' => 'Copyright-Name',
    'language' => 'Sprache',
    'secret_key' => 'Geheimer Schlüssel',
    'site_key' => 'Site-Schlüssel',
    'hostname' => 'Hostname',
    'port' => 'Hafen',
    'encryption' => 'Verschlüsselung',
    'debug' => 'Debuggen',
    'username' => 'Nutzername',
    'application_copyright' => '<strong>Copyright &copy; 2018-%present% <a href="https://rbsoft.org">RBSoft</a></strong>. Alle Rechte vorbehalten.',
    'add_device_instructions' => 'Sie können die folgenden Schritte ausführen, um Ihr Android-Telefon zum System hinzuzufügen.',
    'add_device_step_1' => 'Laden Sie <a href="%app_url%">hier</a> die neueste Version der Android-App herunter. Es ist besser, wenn Sie es direkt auf Ihr Telefon herunterladen.',
    'add_device_step_2' => 'Installieren Sie es auf Ihrem Telefon. Wenn Sie nicht wissen, wie Sie die Apps installieren, die nicht im Play Store verfügbar sind, können Sie <a href="https://android.gadgethacks.com/how-to/android-101-sideload-apps-by-enabling-unknown-sources-install-unknown-apps-0161947/" target="_blank">dieser Anleitung</a> folgen.',
    'add_device_step_3' => 'Öffnen Sie die App nach der Installation. Sie werden aufgefordert, eine Reihe von Berechtigungen zu erteilen. Klicken Sie einfach bei allen Eingabeaufforderungen auf Zulassen oder Ja. Das Anmeldefenster wird angezeigt. Berühren Sie die Schaltfläche "ANMELDEN MIT QR-CODE ANMELDEN", ​​um den unten gezeigten QR-Code zu scannen.',
    'add_device_step_4' => 'Herzlichen Glückwunsch, Sie haben Ihr Android-Handy erfolgreich zum System hinzugefügt. Öffnen Sie jetzt einfach die Absenderseite über das Navigationsmenü und senden Sie Nachrichten.',
    'add_device' => 'Gerät hinzufügen',
    'error_parsing_qr_code' => 'Beim Parsen des QR-Codes ist ein Fehler aufgetreten. Bitte versuchen Sie es erneut zu scannen.',
    'null_value' => 'Unbekannt',
    'android_version' => 'Android-Version',
    'app_version' => 'App Version',
    'error_invalid_schedule_time' => 'Die Zeitplanzeit sollte größer als die aktuelle Zeit sein.',
    'success_messages_scheduled' => '%count% Nachrichten erfolgreich geplant.',
    'success_message_scheduled' => '%count% Nachricht erfolgreich geplant.',
    'success_scheduled' => 'Nachricht erfolgreich geplant.',
    'faqs' => 'FAQs',
    'support' => 'Unterstützung',
    'faqs_link' => '<a target="_blank" href="https://support.rbsoft.org/knowledgebase/355">Hier</a> finden Sie häufig gestellte Fragen.',
    'support_link' => 'Wenn FAQs das aufgetretene Problem nicht beheben, können Sie von <a target="_blank" href="https://support.rbsoft.org">hier</a> aus ein Support-Ticket öffnen.',
    'cron_job_instructions' => 'Fügen Sie einen Cron-Job hinzu, indem Sie den folgenden Befehl in der Linux-Shell ausführen. Wenn Sie das Cpanel- oder Vesta-Panel verwenden, befolgen Sie eine Anleitung von <a target="_blank" href="https://smsgateway.rbsoft.org/docs/setting_up_the_cron_job_1.htm">hier</a> aus, um einen Cron-Job einzurichten.',
    'cron_job' => 'Cron-Job für geplante Nachrichten',
    'success_installation' => 'Ihre Installation wurde erfolgreich abgeschlossen.',
    'schedule' => 'Zeitplan',
    'scheduled' => 'Geplant',
    'tooltip_schedule' => 'Der Zeitplan verwendet die Zeitzone, die Sie auf Ihrer Profilseite festgelegt haben. Stellen Sie daher sicher, dass sie mit der Zeitzone Ihres Geräts übereinstimmt.',
    'error_missing_excel_file' => 'Bitte durchsuchen Sie die Excel-Datei, die Sie hochladen möchten, und wählen Sie sie aus.',
    'send_message_to_contacts' => 'Senden Sie eine Nachricht an die Kontaktliste',
    'contacts_message_placeholder' => 'Sie können einen Platzhalter wie in der folgenden Nachricht gezeigt verwenden, der ihn automatisch durch den entsprechenden Wert ersetzt. Es unterstützt auch das Randomisieren von Nachrichten mit Spintax.
&quot;{Hallo|Hi|Hey} %name%, Wie geht es Ihnen?&quot;',
    'change_subscription' => 'Abonnement ändern',
    'manage_contacts' => 'Kontakte verwalten',
    'subscribed' => 'Gezeichnet',
    'remove_list' => 'Liste entfernen',
    'contacts_list' => 'Kontaktliste',
    'import_contacts' => 'Kontakte importieren',
    'unsubscribe_link' => 'Um sich abzumelden, klicken Sie auf den folgenden Link oder antworten Sie auf "UNSUBSCRIBE %listId%".\n%unsubscribeURL%?number=%number%&listID=%listID%',
    'error_invalid_list_id' => 'Ungültige Listen-ID! Die Kontaktliste konnte nicht gefunden werden.',
    'change_subscription_confirmation' => 'Möchten Sie den Abonnementstatus ausgewählter Kontakte wirklich ändern?',
    'error_already_unsubscribed' => 'Diese Nummer ist bereits von der Liste abgemeldet.',
    'error_no_subscribers' => 'In der Kontaktliste sind keine Abonnenten vorhanden.',
    'error_not_a_subscriber' => 'Diese Nummer ist in der Abonnentenliste nicht vorhanden.',
    'error_invalid_number' => 'Diese Handynummer wird in der Liste nicht gefunden. Bitte geben Sie eine gültige Handynummer an.',
    'success_unsubscribed' => 'Sie wurden von der Kontaktliste abgemeldet.',
    'success_contacts_subscription_changed' => 'Der Abonnementstatus für %count% Kontakte wurde erfolgreich geändert.',
    'success_contact_subscription_changed' => 'Der Abonnementstatus für %count% Kontakt wurde erfolgreich geändert.',
    'success_contacts_removed' => '%count% Kontakte erfolgreich entfernt.',
    'success_contacts_list_removed' => 'Kontaktliste erfolgreich entfernt.',
    'success_contact_removed' => '%count% Kontakt erfolgreich entfernt.',
    'remove_contacts_confirmation' => 'Möchten Sie ausgewählte Kontakte wirklich entfernen?',
    'error_no_contacts_found' => 'In der hochgeladenen Datei wurden keine neuen Kontakte gefunden.',
    'success_contacts_saved' => '%count% Kontakte erfolgreich hinzugefügt.',
    'success_contact_saved' => '%count% Kontakt erfolgreich hinzugefügt.',
    'error_contacts_list_exist' => 'Kontaktliste mit diesem Namen existiert bereits. Bitte geben Sie einen eindeutigen Namen an.',
    'error_contact_exist' => 'Diese Handynummer ist bereits in der Kontaktliste vorhanden.',
    'success_new_contact' => 'Neuer Kontakt erfolgreich hinzugefügt.',
    'error_list_name_required' => 'Der Name der Kontaktliste darf nicht leer sein.',
    'success_create_list' => 'Eine neue Kontaktliste wurde erfolgreich hinzugefügt.',
    'remove_contacts_list_confirmation' => 'Möchten Sie die ausgewählte Kontaktliste wirklich entfernen?',
    'add_contact' => 'Kontakt hinzufügen',
    'contacts' => 'Kontakte',
    'create_list' => 'Kontaktliste erstellen',
    'list_name' => 'Name der Kontaktliste',
    'create' => 'Erstellen',
    'delivered' => 'Geliefert',
    'default' => 'Standard',
    'sim' => 'SIM',
    'error_no_sim_present' => 'Auf dem Steckplatzindex %slot% ist keine SIM-Karte vorhanden. Bitte starten Sie die SMS Gateway-App auf Ihrem Android-Gerät neu, wenn Sie kürzlich die SIM-Karte eingelegt haben.',
    'sent_date' => 'Sendedatum',
    'delivered_date' => 'Lieferdatum',
    'sign_in' => 'Einloggen',
    'sign_in_message' => 'Melden Sie sich an, um Ihre Sitzung zu beginnen',
    'forget_password_link' => 'Ich habe mein Passwort vergessen',
    'error_removing_upgrade_script' => '%type% is successful but There is an error while removing "upgrade.php". Please remove it manually and after that click <a href="index.php">here</a> to login.',
    'error_removing_install_directory' => 'Beim Entfernen des Installationsverzeichnisses ist ein Fehler aufgetreten. Bitte entfernen Sie es manuell, um fortzufahren',
    'error_incorrect_credentials' => 'Diese E-Mail oder dieses Passwort ist falsch.',
    'error_incorrect_api_key' => 'Dieser API-Schlüssel ist ungültig.',
    'success_update' => 'Successfully updated to v%version%. Click <a href="index.php">here</a> to login.',
    'purchase_code' => 'Envato Purchase Code',
    'dashboard' => 'Dashboard',
    'more_info' => 'Mehr Info',
    'sent' => 'Gesendet',
    'failed' => 'Fehlgeschlagen',
    'available' => 'SMS-Guthaben',
    'used' => 'Versendete SMS',
    'queued' => 'In Warteschlange',
    'pending' => 'Ausstehend',
    'profile' => 'Profil',
    'edit_user' => 'Benutzer bearbeiten',
    'close' => 'Schließen',
    'save_changes' => 'Änderungen speichern',
    'add_webhook' => 'WebHook für empfangene Nachrichten hinzufügen',
    'webhook_url' => 'WebHook URL',
    'api' => 'API',
    'api_test' => 'Link zur Test-API generieren',
    'api_key' => 'API Key',
    'generate_link' => 'Link generieren',
    'manage_users' => 'Benutzer verwalten',
    'select_user' => 'Benutzer auswählen',
    'messages' => 'Nachrichten',
    'sender' => 'SMS versenden',
    'devices' => 'Geräte',
    'select_device' => 'Gerät auswählen',
    'online' => 'Online',
    'download_example_excel' => 'Beispieldatei downloaden',
    'installation' => 'Installation',
    'installation_of_app' => 'Installation von %app%',
    'toggle_navigation' => 'Navigation umschalten',
    'error_creating_config' => 'Konfigurationsdatei kann nicht erstellt werden. Stellen Sie sicher, dass dieses Skript über die erforderlichen Berechtigungen zum Erstellen einer Datei verfügt.',
    'error_device_not_found' => 'Dieses Gerät ist in der Datenbank nicht vorhanden.',
    'error_email_registered' => 'Diese Email ist bereits registriert.',
    'error_credits_depleted' => 'Ihr Guthaben reicht nicht aus, um diesen Vorgang abzuschließen. Bitte holen Sie sich mehr Credits, um fortzufahren.',
    'error_send_email_register' => 'Beim Senden von Registrierungsinformationen per E-Mail ist ein Fehler aufgetreten. %errorMessage%',
    'success_registration' => 'Benutzer wurde erfolgreich zur Datenbank hinzugefügt. Sie erhalten in Kürze eine Registrierungsinformation per E-Mail.',
    'add_user_form_title' => 'Benutzer hinzufügen',
    'error_dialog_title' => 'Fehler!',
    'success_dialog_title' => 'Erfolgreich',
    'name' => 'Name',
    'error_name_empty' => 'Name darf nicht leer sein.',
    'device_name' => 'Gerätename',
    'email' => 'E-Mail',
    'device_model' => 'Gerätemodell',
    'password' => 'Passwort',
    'confirm_email' => 'E-Mail bestätigen',
    'create_user' => 'Benutzer erstellen',
    'remove' => 'Löschen',
    'database_server' => 'Datenbank Server',
    'database_name' => 'Datenbank Name',
    'database_user' => 'Datenbank Benutzer',
    'database_password' => 'Datenbank Passwort',
    'install' => 'Installieren',
    'total_messages' => 'Nachrichten insgesamt',
    'connected_devices' => 'Verbundene Geräte',
    'mobile_numbers' => 'Handynummern',
    'mobile_numbers_placeholder' => '+491234567890,+4912345678901',
    'device_status' => 'Gerätestatus',
    'date_added' => 'Hinzugefügt am',
    'error_uploading_excel_file' => 'Beim Hochladen dieser Datei ist ein Problem aufgetreten. Bitte versuchen Sie es später erneut.',
    'error_no_device_selected' => 'Bitte wählen Sie mindestens ein Gerät aus, um Nachrichten zu senden.',
    'error_unable_to_remove_users' => 'Ausgewählte Benutzer können nicht entfernt werden.',
    'error_unable_to_remove_devices' => 'Ausgewählte Geräte können nicht entfernt werden.',
    'remove_devices_confirmation' => 'Möchten Sie die ausgewählten Geräte wirklich entfernen?',
    'remove_messages_confirmation' => 'Möchten Sie die ausgewählten Nachrichten wirklich entfernen?',
    'remove_users_confirmation' => 'Ausgewählte Benutzer werden zusammen mit ihren Nachrichten entfernt. Möchten Sie ausgewählte Benutzer wirklich entfernen?',
    'search_form_title' => 'Nachrichten durchsuchen',
    'success_edit_user' => 'Die Daten für den Benutzer %name% [<a href="mailto:%email%">%email%</a>] wurden erfolgreich gespeichert.',
    'all_users' => 'Alle Nutzer',
    'all_devices' => 'Alle Geräte',
    'unknown_device' => 'Unbekannt',
    'credits' => 'Guthaben',
    'max_devices' => 'Max. Anzahl Geräte',
    'mobile_number' => 'Handynummer',
    'last_login' => 'Letzte Anmeldung',
    'split' => 'Nachrichten zwischen Geräten aufteilen',
    'status' => 'Status',
    'status_all' => 'Alle',
    'start_date' => 'Anfangsdatum',
    'end_date' => 'Enddatum',
    'page_no' => 'Seiten Nr.',
    'select_all' => 'Alle auswählen',
    'search' => 'Suchen',
    'export' => 'Exportieren',
    'resend' => 'Erneut senden',
    'delay' => 'Verzögerung',
    'timezone' => 'Zeitzone',
    'device' => 'Gerät',
    'save' => 'Speichern',
    'page_limit' => 'Anzahl Nachrichten pro Seite',
    'received' => 'Empfangen',
    'primary_device' => 'Primärgerät',
    'device_settings' => 'Geräteeinstellungen',
    'messages_count' => 'Zeige ${start}-${end} von ${result.totalCount} Nachrichten',
    'no_messages_found' => '0 Nachrichten gefunden.',
    'error_dialog_message' => 'Der Vorgang konnte nicht abgeschlossen werden.',
    'success_dialog_message' => 'Der Vorgang wurde erfolgreich abgeschlossen.',
    'error_devices_limit_reached' => 'Das für dieses Konto zulässige Limit der aktiven Geräte ist erreicht.',
    'error_max_devices_not_number' => 'Die maximale Anzahl der Geräte muß eine Zahl sein.',
    'error_credits_not_number' => 'SMS-Guthaben muß eine Nummer sein.',
    'error_password_incorrect' => 'Aktuelles Passwort ist nicht korrekt.',
    'error_delay_limit' => "Die Verzögerung muss zwischen 0 und 120 Sekunden liegen.",
    'error_delay_not_numeric' => "Die Verzögerung muss numerisch sein.",
    'error_device_name' => 'Der Gerätename sollte weniger als 25 Zeichen umfassen.',
    'success_device_settings' => 'Geräteeinstellungen erfolgreich gespeichert',
    'success_password_changed' => 'Ihr Passwort wurde erfolgreich geändert!',
    'success_settings_changed' => 'Ihre Einstellungen wurden erfolgreich geändert.',
    'change_password' => 'Passwort ändern',
    'current_password' => 'Aktuelles Passwort',
    'new_password' => 'Neues Passwort',
    'confirm_password' => 'Passwort wiederholen',
    'settings' => 'Einstellungen',
    'delay_setting' => 'Verzögerung zwischen Nachrichten (0-120 Sekunden)',
    'report_delivery_setting' => 'Fordern Sie für jede von Ihnen gesendete Nachricht einen Zustellbericht an (Nur SMS)',
    'success_devices_removed' => '%count% Geräte erfolgreich entfernt.',
    'success_device_removed' => '%count% Gerät erfolgreich entfernt.',
    'success_users_removed' => '%count% Benutzer erfolgreich entfernt.',
    'success_user_removed' => '%count% Benutzer erfolgreich entfernt.',
    'success_messages_removed' => '%count% Nachrichten erfolgreich entfernt.',
    'success_message_removed' => '%count% Nachricht erfolgreich entfernt.',
    'success_messages_sent' => '%count% Nachrichten erfolgreich versendet.',
    'success_message_sent' => '%count% Nachricht erfolgreich versendet.',
    'error_zero_messages' => 'Es gibt keine Nachrichten zum versenden.',
    'error_invalid_request_format' => 'Ungültiges Anforderungsformat',
    'error_use_valid_number' => 'Bitte verwenden Sie eine gültige Handynummer.',
    'reset_password' => 'Zurücksetzen',
    'error_email_not_exist' => 'Diese E-Mail existiert nicht in der Datenbank.',
    'error_link_expired' => 'Ihr Passwort-Zurücksetzen-Link ist abgelaufen.',
    'error_link_invalid' => 'Ihr Passwort-Zurücksetzen-Link ist ungültig.',
    'error_send_email_reset_password' => 'Beim Senden von Informationen zum Zurücksetzen des Passworts ist ein Fehler aufgetreten.',
    'success_reset_password' => 'Ihr Passwort wurde erfolgreich zurückgesetzt! Sie erhalten in Kürze neue Zugangsdaten per E-Mail.',
    'success_password_reset_link' => 'Sie erhalten in Kürze eine E-Mail zum Zurücksetzen des Passworts.',
    'forget_password' => 'Passwort vergessen',
    'reset_your_password' => 'Setze dein Passwort zurück',
    'message' => 'Nachricht',
    'send' => 'Senden',
    'send_multiple_messages' => 'Mehrere Nachrichten senden',
    'send_message' => 'Nachricht senden',
    'php_integration' => 'PHP-Integration',
    'php_integration_instruction' => 'Fügen Sie folgenden Code in Ihre PHP-Datei ein, um das Senden von Nachrichten zu starten.',
    'webhook_example' => 'WebHook-Beispielskript',
    'webhook_instruction' => 'Erstellen Sie ein Skript mit dem folgenden Inhalt und geben Sie die URL als WebHook an.',
    'success_save_webhook' => 'WebHook wurde erfolgreich gespeichert.',
    'error_invalid_webhook_url' => 'Bitte geben Sie eine gültige URL für WebHook an.',
    'success_remove_webhook' => 'WebHook wurde erfolgreich entfernt.',
    'send_single_message' => 'Einzelne Nachricht senden',
    'send_bulk_messages' => 'Massennachrichten senden',
    'get_balance' => 'SMS-Guthaben abfragen',
    'get_messages'=> 'Erhalten Sie Nachrichten und ihren aktuellen Status',
    'get_credits' => 'Guthaben aufladen',
    'c#_integration' => 'C# Integration',
    'c#_integration_instruction' => 'Erstellen Sie einfach eine Datei mit dem Namen Gateway.cs in Ihrem Projekt und fügen Sie den folgenden Code ein. Sie müssen auch <a href="https://www.nuget.org/packages/Newtonsoft.Json" target="_blank">Newtonsoft.Json NuGet package</a> zu ihrem Projekt hinzufügen.',
    'error_missing_fields' => 'Alle Felder sind erforderlich.',
    'success_sent' => 'Nachricht erfolgreich gesendet.',
    'disconnected' => 'Getrennt',
    'connected' => 'Verbunden',
    'success_register' => 'Vielen Dank für Ihr Interesse an %app%. Sie erhalten in Kürze eine Registrierungsinformation per E-Mail.',
    'register' => 'Anmelden',
    'register_demo' => 'Für einen Test anmelden.',
    'register_sign_in_link' => 'Ich habe bereits eine Mitgliedschaft',
    'error_captcha_failed' => 'Die Captcha-Verifikation ist fehlgeschlagen. Bitte versuchen Sie es erneut.',
    'error_no_active_device_found' => 'Mit diesem Benutzerkonto wurde kein aktives Gerät gefunden.',
    'error_unable_to_connect_user' => 'Es kann keine Verbindung zum Gerät hergestellt werden. Stellen Sie sicher, dass Sie bei der Anwendung auf %device% angemeldet sind.',
    'error_unable_to_connect_other' => 'Es kann keine Verbindung zum Gerät hergestellt werden. Stellen Sie sicher, dass der Benutzer %user%(%userEmail%) in der Anwendung auf %device% angemeldet ist.',
    'error_no_messages_found' => 'In der hochgeladenen Datei wurden keine Nachrichten gefunden.',
    'error_nothing_to_update' => 'Es gibt nichts zum Aktualisieren.',
    'error_blocked_file_extension' => 'Hochladen der Datei nicht möglich. Diese Dateierweiterung ist nicht zulässig.',
    'upload_excel_file' => 'Legen Sie die Excel-Datei hier ab oder klicken Sie zum Hochladen.',
    'upload_excel_file_mobile' => 'Tippen Sie hier, zum hochladen der Excel-Datei.',
    'register_email_subject' => '%app% Admin Panel | Registrierungsinformationen',
    'register_email_body' => '<p>Hallo %user%,</p>

<p>Willkommen im %app% Admin Panel.</p>

<p>Ihre Registrierung wurde bestätigt und Sie haben nun Zugriff auf %app% Admin Panel.</p> 

<p>
Ihre Anmeldedaten:<br/>
Server: <a href="%server%">%server%</a><br/>
Email: %userEmail%<br/>
Passwort: %password%<br/>
</p>

<p>Damit Sie ihr Smartphone als SMS-Gateway nutzen können, müssen Sie die Android-App über folgenden Link %appUrl% herunterladen und auf ihrem Smartphone installieren. Wenn Sie nicht wissen, wie Apps geladen werden sollen, können Sie die APK-Datei anhand der Anleitung unter dem folgenden Link installieren.</p>

<p><a href="https://android.gadgethacks.com/how-to/android-basics-enable-unknown-sources-sideload-apps-0161947/">https://android.gadgethacks.com/how-to/android-basics-enable-unknown-sources-sideload-apps-0161947/</a></p>

<p>Sie können sich mit den oben angegebenen Anmeldeinformationen anmelden oder die Schaltfläche "SIGN IN USING QR CODE" verwenden und den QR-Code im Anhang scannen, um sich automatisch anzumelden.</p>

<p>Um sich in der APP anzumelden verwenden Sie die oben aufgeführten Anmeldedaten.</p>

<p>Sie haben %credits%. Sie können Nachrichten mit %devices% senden. Sie können %contacts% speichern. Ihre Credits sind bis %expiryDate% gültig. Wenn Sie eines dieser Limits ändern möchten, wenden Sie sich bitte an <a href="mailto:%adminEmail%">%adminEmail%</a>.</p>

<p>
Mit freundlichen Grüßen,<br/>
%admin%
</p>',

    'reset_password_email_subject' => '%app% Admin Panel | Passwort zurücksetzen',
    'reset_password_email_body' => '<p>Hallo %user%,</p>

<p>Ihr Passwort wurde erfolgreich zurückgesetzt. Sie können sich mit folgenden Anmeldeinformationen im %app% Admin Panel anmelden.</p>
    
<p>
Ihre Anmeldedaten:<br/>
Server: <a href="%server%">%server%</a><br/>
Email: %userEmail%<br/>
Passwort: %password%<br/>
</p>
    
<p>Bei Fragen wenden Sie sich bitte an <a href="mailto:%adminEmail%">%adminEmail%</a>.</p>
    
<p>
Mit freundlichen Grüßen,<br/>
%admin%
</p>',
    'reset_password_link_email_subject' => '%app% Admin Panel | Link zum Zurücksetzen des Passworts',
    'reset_password_link_email_body' => '<p>Hallo %user%,</p>

<p>Bitte benutzen Sie den folgenden Link, um Ihr Passwort zurückzusetzen. Dieser Link läuft in 24 Stunden ab.</p>

<h2><a href="%server%/reset-password.php?email=%userEmail%&code=%code%">Klicken Sie hier, um Ihr Passwort zurückzusetzen</a></h2>
 
<p>Bei Fragen wenden Sie sich bitte an %adminEmail%.</p>

<p>
Mit freundlichen Grüßen,<br/>
%admin%
</p>',
    'edit_user_subject' => '%app% | Aktualisierte Gutschriften für Nachrichten und Gerätebegrenzung',
    'edit_user_email_body' => '<p>Hallo %user%,</p>

<p>Sie haben %credits%. Sie können Nachrichten mit %devices% senden. Sie können %contacts% speichern. Ihre Credits sind bis %expiryDate% gültig. Wenn Sie eines dieser Limits ändern möchten, wenden Sie sich bitte an <a href="mailto:%adminEmail%">%adminEmail%</a>.</p>
    
<p>Bei Fragen wenden Sie sich bitte an %adminEmail%.</p>

<p>
Mit freundlichen Grüßen,<br/>
%admin%
</p>'
];

// Application specific
include __DIR__ . "/../app.php";